<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access\Wordpress;

use ZOOlanders\YOOessentials\Access\AccessRule;

class LanguageRule implements AccessRule
{
    public function group() : string
    {
        return 'site';
    }

    public function name() : string
    {
        return 'Language';
    }

    public function namespace() : string
    {
        return 'yooessentials_access_language';
    }

    public function description() : string
    {
        return 'Validates if the site current language matches the selection.';
    }

    public function resolve($props, $node) : bool
    {
        if (!isset($props->languages)) {
            return true;
        }

        $selection = $props->languages;
        $current = \determine_locale();

        return in_array($current, (array) $selection);
    }

    public function fields() : array
    {
        return [
            "{$this->namespace()}.languages" => [
                'type' => 'select',
                'description' => 'The languages that the site current language must match. Use the shift or ctrl/cmd key to select multiple entries.',
                'attrs' => [
                    'multiple' => true,
                    'class' => 'uk-height-small uk-resize-vertical'
                ],
                'options' => $this->getAvailableLanguages()
            ]
        ];
    }

    protected function getAvailableLanguages() : array
    {
        static $availableLanguages = [];

        if (empty($availableLanguages)) {
            require_once \ABSPATH . 'wp-admin/includes/translation-install.php';

            $languages = \get_available_languages();
            $translations = \wp_get_available_translations();

            $availableLanguages['English (United States)'] = 'en_US';

            foreach ($languages as $language) {
                $name = $translations[$language]['native_name'] ?? $language;
                $availableLanguages[$name] = $language;
            }
        }

        return $availableLanguages;
    }
}
